{*
* 2007-2017 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2017 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{function name="categories" nodes=[] depth=0}
  {strip}
    {if $nodes|count}
      <ul class="category-sub-menu">
        {foreach from=$nodes item=node}
          <li data-depth="{$depth}">
            {if $depth===0}
              <a href="{$node.link}">{$node.name}</a>
              {if $node.children}
                <span class="collapse-icons" data-bs-toggle="collapse" data-bs-target="#exCollapsingNavbar{$node.id}">
                  <i class="fa fa-angle-down add" aria-hidden="true"></i>
                  <i class="fa fa-angle-up remove" aria-hidden="true"></i>
                </span>
                <div class="collapse" id="exCollapsingNavbar{$node.id}">
                  {categories nodes=$node.children depth=$depth+1}
                </div>
              {/if}
            {else}
              <a class="category-sub-link" href="{$node.link}">{$node.name}</a>
              {if $node.children}
                <span class="arrows collapse-icons" data-bs-toggle="collapse" data-bs-target="#exCollapsingNavbar{$node.id}">
                   <i class="fa fa-angle-down add" aria-hidden="true"></i>
                   <i class="fa fa-angle-up remove" aria-hidden="true"></i>
                </span>
                <div class="collapse" id="exCollapsingNavbar{$node.id}">
                  {categories nodes=$node.children depth=$depth+1}
                </div>
              {/if}
            {/if}
          </li>
        {/foreach}
      </ul>
    {/if}
  {/strip}
{/function}


{if !empty($categories.children)}
  <div class="block block-toggle block-categories block-links js-block-toggle">
    <h5 class="block-title"><span><a href="{$categories.link nofilter}">{$categories.name}</a></span> </h5>
    <div class="category-top-menu block-content">
      {categories nodes=$categories.children}
    </div>
  </div>
{/if}